﻿using System;

namespace Literals
{
    class Program
    {
        static void Main(string[] args)
        {
            // Uwaga: Te dodatkowe nawiasy klamrowe określają zakres - w ten sposób możemy
            // umieścić w jednej metodzie wiele przykładów, z których każdy używa
            // zmiennej "myString". Dzieje się tak, gdyż zmienna ta jest lokalna
            // i dostępna wyłącznie w zakresie w jakim została umieszczona.

            {
                // Listing 10-2. Literał łańcuchowy.
                string myString = "Literał łańcuchowy";
                Console.WriteLine(myString);
            }

            {
                // Listing 10-3. Inicjalizacja łańcucha znaków przy użyciu literałów znakowych.
                string myString = new string(new[] { 'W', 'i', 't', 'a', 'j', ' ', '"', 'Ś', 'w', 'i', 'e', 'c', 'i', 'e', '"' });
                Console.WriteLine(myString);
            }

            // Listing 10-4. Zastosowanie znaku @ w celu uniknięcia konieczności stosowania odwrotnych ukośników.
            string multiLineString =
            @"Dużo 
wierszy  
        i tabulacji!";
            Console.WriteLine(multiLineString);
        }

    }
}
